#version 330
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Bauble Space 29Mod01.fsh   by  SnoopethDuckDuck   
//https://www.shadertoy.com/view/7lBBRD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_STEPS 400
#define MAX_DIST 100.
#define SURF_DIST .001
// start Common  //
#define pi 3.14159

#define thc(a,b) tanh(a*cos(b))/tanh(a)
#define ths(a,b) tanh(a*sin(b))/tanh(a)
#define sabs(x) sqrt(x*x+1e-2)
//#define sabs(x, k) sqrt(x*x+k)-0.1

#define rot(a) mat2(cos(a), -sin(a), sin(a), cos(a))

#define sfloor(a,b) (floor(b) + 0.5 + 0.5 * tanh(a * (fract(b) - 0.5)) / tanh(0.5 * a))

float test(in vec2 uv, float res)
{
    uv -= floor(uv) + 0.5;

    float k = 10. / res;
    float m = 0.25;
    
    float d = length(uv);
    float s = smoothstep(-k, k, -length(uv) + m);
       
    for (int i = 0; i < 6; i++) {
        uv = abs(uv) - m;
        m *= 0.5;
        s = max(s, smoothstep(-k, k, -length(uv) + m));
    }
    
    return s;
}

float cc(float a, float b) {
    float f = thc(a, b);
    return sign(f) * pow(abs(f), 0.25);
}

float cs(float a, float b) {
    float f = ths(a, b);
    return sign(f) * pow(abs(f), 0.25);
}

vec3 pal(in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d) {
    return a + b*cos( 6.28318*(c*t+d) );
}

float h21(vec2 a) {
    return fract(sin(dot(a.xy, vec2(12.9898, 78.233))) * 43758.5453123);
}

float mlength(vec2 uv) {
    return max(abs(uv.x), abs(uv.y));
}

float mlength(vec3 uv) {
    return max(max(abs(uv.x), abs(uv.y)), abs(uv.z));
}

float smin(float a, float b) {
    float k = 0.12;
    float h = clamp(0.5 + 0.5 * (b-a) / k, 0.0, 1.0);
    return mix(b, a, h) - k * h * (1.0 - h);
}
// end Common //
vec3 test2(vec2 uv) {
    uv -= floor(uv + 0.5);
    float d = 9. * cos(abs(uv.y) + abs(uv.x) + 2. * cos(length(uv) + 0.25 * 3.14159));  
    vec3 e = vec3(0.5);   
    return pal(d, e, e, e, 0.35 * vec3(0,1,2)/3.);
}

#define FK(k) floatBitsToInt(k*k/7.)^floatBitsToInt(k)
float hash(float a, float b) {
    int x = FK(a), y = FK(b);
    return float((x*x+y)*(y*y-x)-x)/2.14e9;
}

vec3 erot(vec3 p, vec3 ax, float ro) {
  return mix(dot(ax, p)*ax, p, cos(ro)) + cross(ax,p)*sin(ro);
}

vec3 face(vec3 p) {
     vec3 a = abs(p);
     return step(a.yzx, a.xyz)*step(a.zxy, a.xyz)*sign(p);
}

float sdBox(vec3 p, vec3 s) {
    p = abs(p)-s;
	return length(max(p, 0.))+min(max(p.x, max(p.y, p.z)), 0.);
}

vec3 getRo() {
    vec2 m = iMouse.xy/iResolution.xy;

    float r = 7.5;
    float t = 0.1 * iTime;

    vec3 ro =  vec3(r * cos(t), 1. * cos(0.4 * t), r * sin(t));
    //ro.yz *= rot(-m.y*3.14+1.);
    //ro.xz *= rot(-m.x*6.2831);
    return ro;
}

float GetDist(vec3 p) {
    //p.xz *= rot(p.y - 0.2 * iTime);

    float d = length(p) - 2.;
    //d = length(p.xz) - 1.- exp(0.4 * sabs(p.y));
    //float d = sdBox(p, vec3(0.75)) - 1.;
   //   
  
    
    vec2 rp = getRo().xz - p.xz;
    float dr = length(rp);
    //float a = atan(rp.x, rp.y);
  
    float val = 0.;
    float m = 0.45;// - 0.4 * cos(0.2 * p.y + iTime);
    for (float i = 0.; i < 6.; i++) {
        vec3 fr = m * p - floor(m*p + 0.5);//fract(m*p) - 0.5;
        val += exp(4. + 0. * cos(0.2 * p.y + iTime) -val * 16.- 0.15 * m * length(p) - 13. * length(fr));
        m *= 1.5;
    }
    
    float fo = exp(-0.5 * length(p));
    d -= 1. * val;
    
    float d2 = length(p - getRo()) - 0.5;
    d = -smin(-d, d2);
    d = max(d, length(p) - 1. * dr);
    //d = -smin(d,-d2);
    return 0.08 * d;
}

float RayMarch(vec3 ro, vec3 rd, float z) {
	
    float dO=0.;
    float s = sign(z);
    for(int i=0; i<MAX_STEPS; i++) {
    	vec3 p = ro + rd*dO;
        float dS = GetDist(p);
        if (s != sign(dS)) { z *= 0.5; s = sign(dS); }
        if(abs(dS)<SURF_DIST || dO>MAX_DIST) break;
        dO += dS*z; 
    }
    
    return min(dO, MAX_DIST);
}

vec3 GetNormal(vec3 p) {
	float d = GetDist(p);
    vec2 e = vec2(.001, 0);
    
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    
    return normalize(n);
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i);
    return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
	
    vec3 ro = getRo();
    
    vec3 rd = GetRayDir(uv, ro, vec3(0), 1.);
    vec3 col = vec3(0);
   
    float d = RayMarch(ro, rd, 1.);

    float IOR = 1.05;
    vec3 p = ro + rd * d;
    if(d<MAX_DIST) {
        
        vec3 n = GetNormal(p);
        vec3 r = reflect(rd, n);

        vec3 pIn = p - 4. * SURF_DIST * n;
        vec3 rdIn = refract(rd, n, 1./IOR);
        float dIn = RayMarch(pIn, rdIn, -1.);
        
        vec3 pExit = pIn + dIn * rdIn;
        vec3 nExit = -GetNormal(pExit); // *-1.; ?

        float dif = dot(n, normalize(vec3(1,2,3)))*.5+.5;
        col = vec3(1);
        
        float fres = pow(1. + dot(rd, n), 3.);
        float v = dot(abs(n), abs(r));
        vec3 e = vec3(0.5);
        //col *= pal(n.y, e, e, e, 0.4 * vec3(0,1,2)/3.);
        n = 0.98 + 0.05 * n;;
        vec3 c1 = test2(n.xz).rgb;
        vec3 c2 = test2(n.yx).rgb;
        vec3 c3 = test2(n.zy).rgb;
        
        vec3 q = 1.-abs(p);
        //p *= (1.-p) * 4.;
        q = clamp(q, -0.2, 1.);
        vec3 c = q.z * c1 + q.x * c2 + q.y * c3;
        col *= c;
        vec3 col2 = pal((1./3.) * sfloor(40., 0.5 * log(length(p)) - 0.8 * iTime), c, c, e, 0.5 * vec3(0,1,2)/3.);
        col *= col2;
        col = mix(col, vec3(0.1), fres * (1. - exp(3.2 - 1. * length(p))));
    }
    col = clamp(col,0.,1.);
    //if (length(p) > 0.5)
      //  col = vec3(0);
    col *= clamp(exp(3.2-1. * length(p)),0.,1.);
    col = pow(col, vec3(.4545));	// gamma correction
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
//vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc); // * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

